//
//  StudyCollectionViewCell.swift
//  OnlineBanking
//
//  Created by Marvin Kowalewski on 14.02.23.
//

import UIKit

// https://www.youtube.com/watch?v=aU_kTzMZHQ8&t=248s
class StudyCollectionViewCell: UICollectionViewCell {
    
    @IBOutlet weak var studyImageView: UIImageView!
    
    @IBOutlet weak var titleLabel: UILabel!
    
    func setup(with study: Study) {
        studyImageView.image = study.image
        titleLabel.text = study.title
        //titleLabel.textColor = Colors.carmine
        
        studyImageView.layer.cornerRadius = 20.0
        
        
        if(study.title == "Instant Messenger") {
            titleLabel.alpha = 0.5
            studyImageView.alpha = 0.6
            //titleLabel.textColor = .black
        }
        if(study.title == "3D Navigation") {
            titleLabel.alpha = 0.5
            studyImageView.alpha = 0.6
            //titleLabel.textColor = .black
        }
        if(study.title == "Handabdruck Scanner") {
            titleLabel.alpha = 0.5
            studyImageView.alpha = 0.6
            //titleLabel.textColor = .black
        }
        if(study.title == "Check Your Tasks") {
            titleLabel.alpha = 0.5
            studyImageView.alpha = 0.6
            //titleLabel.textColor = .black
        }
        
        
    }
}
